import sandbox.sdk2 as sdk2

import sandbox.projects.quasar.image_builds.base_image_build.tv_mediatek as base
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.platform.mt9632_cv as mt9632_cv
import sandbox.projects.quasar.resource_types.tv as qrt


class QuasarBuildMt9632CvImage(base.QuasarBuildTvMtkCvImageBase):
    """
    Build full image for quasar device and publish it as a resource
    """
    class Parameters(base.QuasarBuildTvMtkCvImageBase.Parameters):
        with sdk2.parameters.String('Product target', required=True) as build_product_target_name:
            for name in mt9632_cv.target_names:
                build_product_target_name.values[name] = None
        secret_device_keys_key = sdk2.parameters.String(
            'Yav secret key with device public key inside', default='mt9632.pem')

    class BuildConfig(base.QuasarBuildTvMtkCvImageBase.BuildConfig):
        platform = quasar_platform.Platform.YANDEX_TV_MT9632_CV
        platform_board = 'cv_mt9632'
        mediatek_device = 'm7332_eu'
        image_resource_type = qrt.AndroidTvMt9632CvImage
        ota_resource_type = qrt.AndroidTvMt9632CvOtaImage
        uniota_resource_type = qrt.AndroidTvMt9632CvUniotaImage
