from sandbox import sdk2

import sandbox.projects.quasar.image_builds.base_image_build.tv_mediatek as base
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.platform.mt9632_cvte as mt9632_cvte
import sandbox.projects.quasar.resource_types.tv as qrt


class QuasarBuildMt9632CvteImage(base.QuasarBuildTvMtkCvteImageBase):
    """
    Build full image for quasar device and publish it as a resource
    """
    class Parameters(base.QuasarBuildTvMtkCvteImageBase.Parameters):
        with sdk2.parameters.String('Product target', required=True) as build_product_target_name:
            for name in mt9632_cvte.target_names:
                build_product_target_name.values[name] = None
        secret_device_keys_key = sdk2.parameters.String(
            'Yav secret key with device public key inside', default='yandex_tv_mt9632_cvte.pem')

    class BuildConfig(base.QuasarBuildTvMtkCvteImageBase.BuildConfig):
        platform = quasar_platform.Platform.YANDEX_TV_MT9632_CVTE
        platform_board = 'cvte_mt9632'
        mediatek_device = 'm7332_eu'
        image_resource_type = qrt.AndroidTvMt9632CvteImage
        ota_resource_type = qrt.AndroidTvMt9632CvteOtaImage
        uniota_resource_type = qrt.AndroidTvMt9632CvteUniotaImage
        rom_filename_prefix = 'allupgrade706_8GB_1P5GB'
