import sandbox.sdk2 as sdk2
import sandbox.common.enum as sb_enum

import sandbox.projects.quasar.utils as quasar_utils
import sandbox.projects.quasar.resource_types as qrt
import sandbox.projects.quasar.resource_types.tv as tv_resource_types
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.image_builds.base_image_build.quasar as quasar_base
import sandbox.projects.quasar.image_builds.base_image_build.amlogic_android as amlogic_android_base
import sandbox.projects.quasar.image_builds.pluto.base as pluto_base


class SoC(sb_enum.Enum):
    S805X2 = 's805x2'
    S905Y4 = 's905y4'


class QuasarBuildPlutoImage(amlogic_android_base.QuasarBuildAmlogicAndroidImage):
    class ArtifactsConfig(object):
        image_resource_type = tv_resource_types.AndroidTvPlutoImage
        ota_resource_type = tv_resource_types.AndroidTvPlutoOtaImage
        target_files_resource = tv_resource_types.AndroidTvPlutoTargetFiles

    class Parameters(amlogic_android_base.QuasarBuildAmlogicAndroidImage.Parameters):
        param_creator = quasar_base.ParameterCreator(quasar_platform.Platform.PLUTO)
        with sdk2.parameters.String('SoC', required=True, default=SoC.S805X2) as soc:
            for _soc in list(SoC):
                soc.values[_soc] = _soc
        custom_manifest = param_creator.create_custom_manifest_parameter()
        ota_max_size = param_creator.create_ota_max_size_parameter()

        sign_keys_secret = sdk2.parameters.String(
            'YAV secret with ota keys tarball, should have file keys.tgz',
            default='ver-01g1fyngeckr228pnzeadwqj65')
        secureboot_keys_secret = sdk2.parameters.String(
            'YAV secret with secureboot keys tarball, should have files: aml-user-key.sig',
            default='ver-01fxqfbrwzj80vagj3zwk4q22x')
        tdk_key_secret = sdk2.parameters.String(
            'YAV secret with tdk private key: tdk_keys.tgz',
            default='ver-01fzg58ctqszjgt7v50bhdtgar')
        rabbit_hole_key_secret = sdk2.parameters.String(
            'YAV secret with rabbit_hole rsa private key: rh_public.pem',
            default='ver-01fzzses1z6z6sqprkz1sw97vt')
        avb_key_secret = sdk2.parameters.String(
            'YAV secret with avb rsa private key: avb_private.pem',
            default='ver-01fx7yvgw86kpqmfbvp15bezag')

        _container = quasar_utils.LastStableContainer(
            'Execution container', resource_type=qrt.QuasarYandexSmartDeviceLxcImage)

    class BuildConfig(pluto_base.PlutoBuildConfig):
        downloaded_artifacts_config = tv_resource_types.AndroidTvArtifactsConfig
        downloaded_artifacts = tv_resource_types.AndroidTvArtifacts
