from sandbox import sdk2

from sandbox.projects.quasar import utils as quasar_utils
from sandbox.projects.quasar import resource_types as qrt
from sandbox.projects.quasar.resource_types import tv as tvrt
from sandbox.projects.quasar import platform
from sandbox.projects.quasar.image_builds.base_image_build import quasar as quasar_base
from sandbox.projects.quasar.image_builds.base_image_build import buildroot as buildroot_base


class QuasarBuildPlutoLinuxImage(buildroot_base.QuasarBaseBuildrootImageBuildTask):
    """
    Build buildroot-based Linux image for pluto sideload in factory
    mode and publish it as a resource.
    """

    BUILDROOT_CONFIG = 'yandex_pluto_s805x2'

    class Parameters(buildroot_base.QuasarBaseBuildrootImageBuildTask.Parameters):
        param_creator = quasar_base.ParameterCreator(platform.Platform.PLUTO)
        custom_manifest = param_creator.create_custom_manifest_parameter()

        secureboot_keys_secret = sdk2.parameters.String(
            'YAV secret should have file aml-user-key.sig',
            default='ver-01fxqfbrwzj80vagj3zwk4q22x')

        tdk_keys_secret = sdk2.parameters.String(
            'YAV secret should have file tdk_keys.tgz',
            default='ver-01fzg58ctqszjgt7v50bhdtgar')

        _container = quasar_utils.LastStableContainer(
            'Execution container',
            resource_type=qrt.QuasarYandexSmartDeviceLxcImage)

    class BuildConfig(buildroot_base.QuasarBaseBuildrootImageBuildTask.BuildConfig):
        @property
        def platform(self):
            return platform.Platform.PLUTO

        @property
        def default_repository_tag(self):
            return 'pluto/master'

        @property
        def buldroot_cache_platform(self):
            return self.default_buildroot_cache_platform

    @property
    def buildroot_config_name(self):
        return self.BUILDROOT_CONFIG

    @property
    def with_quasar_daemons(self):
        return False

    def prepare_build_command(self):
        config = {
            'BR2_PACKAGE_TEE_SUPPORT_TA_SIGN': 'y',
            'BR2_PACKAGE_TEE_SUPPORT_TA_SIGN_KEYS_PATH': self.yav_export_tar(str(self.Parameters.tdk_keys_secret), 'tdk_keys.tgz'),
            'BR2_TARGET_ROOTFS_AMLOGIC_SIGN_KEY': self.yav_export_secure_tar(
                'vendor/amlogic/src/uboot/bl33/v2019/board/amlogic/pluto_s805x2/device-keys',
                str(self.Parameters.secureboot_keys_secret),
                'aml-user-key.sig'),
            'BR2_TARGET_ROOTFS_AMLOGIC_SIGN': 'y'}

        build_command = '. ./build/envsetup.sh && lunch {} && m {}'.format(
            self.BUILDROOT_CONFIG,
            ' '.join('{}={}'.format(k, v) for k, v in config.items()),
        )

        return build_command

    def publish_resources(self):
        self.publish_image(resource_type=tvrt.QuasarPlutoLinuxImage,
                           secureboot=True,
                           fastboot=True,
                           version=None)
        self.publish_image(resource_type=tvrt.QuasarPlutoLinuxImage,
                           secureboot=False,
                           fastboot=True,
                           version=None)
