from sandbox import sdk2

from sandbox.projects.quasar import platform
from sandbox.projects.quasar import resource_types as qrt
from sandbox.projects.quasar import utils as quasar_utils
from sandbox.projects.quasar.image_builds.base_image_build import linkplay as linkplay_base
from sandbox.projects.quasar.image_builds.base_image_build import quasar as quasar_base


class QuasarBuildPrestigioSmartMateImage(linkplay_base.QuasarLinkplayImageBuildTask):
    """
    Build full image for quasar Prestigio Smart Mate device and publish it as a resource
    """

    class Parameters(linkplay_base.QuasarLinkplayImageBuildTask.Parameters):
        param_creator = quasar_base.ParameterCreator(platform.Platform.PRESTIGIO_SMART_MATE)

        quasar_daemons = param_creator.create_daemons_parameter()

        _container = quasar_utils.LastStableContainer(
            'Execution container',
            resource_type=qrt.QuasarLinkplayA98LxcImage)

        # Parameters class require to declare at least something from sdk2.parameter to work properly
        with sdk2.parameters.Group('PrestigioSmartMate') as dummy:
            pass

    class BuildConfig(linkplay_base.QuasarLinkplayImageBuildTask.BuildConfig):
        @property
        def platform(self):
            return platform.Platform.PRESTIGIO_SMART_MATE

        @property
        def ota_resource_type(self):
            return qrt.QuasarPrestigioSmartMateOTAImage

        @property
        def default_repository_url(self):
            return 'ssh://bb.yandex-team.ru/quas/prestigiosmartmatea98-firmware.git'
