import sandbox.sdk2 as sdk2

import sandbox.projects.quasar.image_builds.base_image_build.tv_realtek as base
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.platform.rt2871_hikeen as rt2871_hikeen
import sandbox.projects.quasar.platform.rt2861_hikeen as rt2861_hikeen
import sandbox.projects.quasar.resource_types.tv as qrt


class QuasarBuildRt2871HikeenImage(base.QuasarBuildTvRtkImageBase):
    class Parameters(base.QuasarBuildTvRtkImageBase.Parameters):
        with sdk2.parameters.String('Product target', required=True) as build_product_target_name:
            for key in sorted(rt2871_hikeen.target_names):
                build_product_target_name.values[key] = None
        secret_device_keys_key = sdk2.parameters.String(
            'Yav secret key with device public key inside', default='rt2871.pem')
        build_ota_with_bootcode = sdk2.parameters.Bool('Build ota with boot partition.')

    class BuildConfig(base.QuasarBuildTvRtkImageBase.BuildConfig):
        platform = quasar_platform.Platform.YANDEX_TV_RT2871_HIKEEN
        platform_board = 'hikeen_rt2871'
        default_repository_url = 'ssh://gerrit.yandex-team.ru/tv/hikeen-rt2871-nougat_manifest'
        image_resource_type = qrt.AndroidTvRt2871HikeenImage
        ota_resource_type = qrt.AndroidTvRt2871HikeenOtaImage


class QuasarBuildRt2861HikeenImage(base.QuasarBuildTvRtkImageBase):
    class Parameters(base.QuasarBuildTvRtkImageBase.Parameters):
        with sdk2.parameters.String('Product target', required=True) as build_product_target_name:
            for key in sorted(rt2861_hikeen.target_names):
                build_product_target_name.values[key] = None
        secret_device_keys_key = sdk2.parameters.String(
            'Yav secret key with device public key inside', default='rt2861.pem')
        build_ota_with_bootcode = sdk2.parameters.Bool('Build ota with boot partition.')

    class BuildConfig(base.QuasarBuildTvRtkImageBase.BuildConfig):
        platform = quasar_platform.Platform.YANDEX_TV_RT2861_HIKEEN
        platform_board = 'hikeen_rt2861'
        rom_resource_type = qrt.AndroidTvRt2861HikeenImage
        ota_resource_type = qrt.AndroidTvRt2861HikeenOtaImage
