import sandbox.sdk2 as sdk2

import sandbox.projects.quasar.utils as quasar_utils
import sandbox.projects.quasar.resource_types.tv as tv_resource_types
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.image_builds.base_image_build.quasar as quasar_base
import sandbox.projects.quasar.image_builds.base_image_build.amlogic_android as amlogic_android_base
import sandbox.projects.quasar.image_builds.yandexmodule_2.base as ym2_base


class QuasarBuildYandexmodule2Image(amlogic_android_base.QuasarBuildAmlogicAndroidImage):
    class ArtifactsConfig(object):
        image_resource_type = tv_resource_types.QuasarYandexmodule2Image
        ota_resource_type = tv_resource_types.QuasarYandexmodule2OTAImage
        target_files_resource = tv_resource_types.QuasarYandexmodule2TargetFiles

    class Parameters(amlogic_android_base.QuasarBuildAmlogicAndroidImage.Parameters):
        quasar_platform = quasar_platform.Platform.YANDEXMODULE_2
        param_creator = quasar_base.ParameterCreator(quasar_platform)
        custom_manifest = param_creator.create_custom_manifest_parameter()
        ota_max_size = param_creator.create_ota_max_size_parameter()

        sign_keys_secret = sdk2.parameters.String(
            'YAV secret with ota keys tarball, should have file keys.tgz',
            default='ver-01eyjygxtjwsmqtt6k4ra3qnpz')
        secureboot_keys_secret = sdk2.parameters.String(
            'YAV secret with secureboot keys tarball, should have files: aml-user-key.sig',
            default='ver-01f00r489nx20dk480gjhfha7c')
        tdk_key_secret = sdk2.parameters.String(
            'YAV secret with tdk private key: tdk_keys.tgz',
            default='ver-01exp6j4ydksk8c7nw4x2fe3v7')
        rabbit_hole_key_secret = sdk2.parameters.String(
            'YAV secret with rabbit_hole rsa private key: rh_public.pem',
            default='ver-01exphpsw3m2negxc5ebq5tmab')
        avb_key_secret = sdk2.parameters.String(
            'YAV secret with avb rsa private key: avb_private.pem',
            default='ver-01expeg7d96sf7xne9bk2n82s9')

        teamcity_token_key_secret = sdk2.parameters.String(
            'YAV secret with teamcity token: robot-quasar-teamcity-token',
            default='ver-01f6237f9s51deh8nt2b5kpt21')

        _container = quasar_utils.LastStableContainer(
            'Execution container', resource_type=tv_resource_types.QuasarYandexmodule2LxcImage)

    class BuildConfig(ym2_base.YandexModule2BuildConfig):
        downloaded_artifacts_config = tv_resource_types.AndroidTvArtifactsConfig
        downloaded_artifacts = tv_resource_types.AndroidTvArtifacts
