from sandbox.projects.quasar import platform
from sandbox.projects.quasar.utils import vcs
from sandbox.projects.quasar.image_builds.base_image_build import quasar as quasar_base

PLATFORM_CODENAME = 'yandexstation_plus'


class YandexStation2BuildConfig(quasar_base.BaseQuasarImageBuildTask.BuildConfig):
    @property
    def platform(self):
        return platform.Platform.YANDEXSTATION_2

    @property
    def default_vcs(self):
        return vcs.VCS.REPO

    @property
    def default_repository_url(self):
        return 'ssh://gerrit.yandex-team.ru/unity/platform/manifest'

    @property
    def default_repository_tag(self):
        return '{}_develop'.format(PLATFORM_CODENAME)

    @property
    def daemons_dest_path(self):
        return None

    @property
    def strip_tool_path(self):
        return None
