import sandbox.projects.sandbox.deploy_binary_task as dbt
import sandbox.common.types.task as ctt
from sandbox import sdk2


class DeployKolhozTasks(sdk2.Task):
    class Parameters(sdk2.Parameters):
        release_type = sdk2.parameters.String("Release type", default="stable")

    def _run_build_tasks(self):
        release_type = self.Parameters.release_type
        tasks = [
            dbt.DeployBinaryTask(
                self,
                description="Child of {}".format(self.id),
                owner=self.owner,
                arcadia_url="arcadia:/arc/trunk/arcadia",
                target="sandbox/projects/quasar/kolhoz/occupy_device",
                attrs={"released": release_type, "task_type": "KOLHOZ_OCCUPY_TASK"},
                use_yt_cache=False,
            ),
            dbt.DeployBinaryTask(
                self,
                description="Child of {}".format(self.id),
                owner=self.owner,
                arcadia_url="arcadia:/arc/trunk/arcadia",
                target="sandbox/projects/quasar/kolhoz/configure_device",
                attrs={"released": release_type, "task_type": "KOLHOZ_DEVICE_CONFIGURE_TASK"},
                use_yt_cache=False,
            ),
            dbt.DeployBinaryTask(
                self,
                description="Child of {}".format(self.id),
                owner=self.owner,
                arcadia_url="arcadia:/arc/trunk/arcadia",
                target="sandbox/projects/quasar/kolhoz/run_tests",
                attrs={"released": release_type, "task_type": "KOLHOZ_TEST_RUN"},
                use_yt_cache=False,
            ),
            dbt.DeployBinaryTask(
                self,
                description="Child of {}".format(self.id),
                owner=self.owner,
                arcadia_url="arcadia:/arc/trunk/arcadia",
                target="sandbox/projects/quasar/kolhoz/release_device",
                attrs={"released": release_type, "task_type": "KOLHOZ_RELEASE_TASK"},
                use_yt_cache=False,
            ),
            dbt.DeployBinaryTask(
                self,
                description="Child of {}".format(self.id),
                owner=self.owner,
                arcadia_url="arcadia:/arc/trunk/arcadia",
                target="sandbox/projects/quasar/kolhoz/kolhoz_smartspeaker_regression",
                attrs={"released": release_type, "task_type": "KOLHOZ_SMART_SPEAKER_REGRESSION"},
                use_yt_cache=False,
            ),
        ]
        for task in tasks:
            task.enqueue()
        return tasks

    def on_execute(self):
        with self.memoize_stage.deploy():
            sub_tasks = self._run_build_tasks()
            raise sdk2.WaitTask(sub_tasks, ctt.Status.Group.FINISH, wait_all=True)
