# This Python file uses the following encoding: utf-8
from sandbox import sdk2
from sandbox import common
from sandbox.projects.common import binary_task


class KolhozOccupyTask(sdk2.Task, binary_task.LastBinaryTaskRelease):
    class Parameters(binary_task.LastBinaryReleaseParameters):
        model_name = sdk2.parameters.String("Model name", default="Яндекс Станция Мини")
        kolhoz_group = sdk2.parameters.String("Kolhoz group", default="YANDEX_TEAM")
        tokens = sdk2.parameters.YavSecret("Kolhoz tokens", default="sec-01dez1a5pfxech6v1h144k1kf4")

        with sdk2.parameters.Output():
            device_id = sdk2.parameters.String("Occupied device id")
            kolhoz_id = sdk2.parameters.String("Kolhoz internal id")

    def on_save(self):
        binary_task.LastBinaryTaskRelease.on_save(self)

    def on_execute(self):
        from yandex_io.pylibs.kolhoz.kolhoz_api import KolhozDevice

        token = self.Parameters.tokens.data()["kolhoz_token"]

        try:
            device = KolhozDevice.get_device(token, self.Parameters.model_name, self.Parameters.kolhoz_group)
        except Exception as ex:
            raise common.errors.TaskFailure("Failed to occupy device: {}".format(ex))
        self.Parameters.device_id = device.device_id
        self.Parameters.kolhoz_id = device.kolhoz_id

    class Requirements(sdk2.Requirements):
        container_resource = 2694802101
