from sandbox import sdk2
from sandbox.projects.common import binary_task


class KolhozReleaseTask(sdk2.Task, binary_task.LastBinaryTaskRelease):
    class Parameters(binary_task.LastBinaryReleaseParameters):
        kolhoz_id = sdk2.parameters.String("Kolhoz device id", required=True)
        device_id = sdk2.parameters.String("Device id")
        tokens = sdk2.parameters.YavSecret("Kolhoz tokens", default="sec-01dez1a5pfxech6v1h144k1kf4")

    def on_save(self):
        binary_task.LastBinaryTaskRelease.on_save(self)

    def on_execute(self):
        from yandex_io.pylibs.kolhoz.kolhoz_api import KolhozDevice

        token = self.Parameters.tokens.data()["kolhoz_token"]

        device = KolhozDevice(self.Parameters.device_id, self.Parameters.kolhoz_id, token)
        device.disconnect()
