import sandbox.sdk2 as sdk2
import sandbox.projects.sandbox.sandbox_lxc_image as sandbox_lxc_image


def read_custom_script(current_path, filename='lxc_image_create.sh'):
    current_dir = sdk2.Path(current_path).parent
    custom_script = current_dir/filename
    return custom_script.read_text() if custom_script.exists() else ''

DESCRIPTION_TEMPLATE = 'Lxc container for building {}'


class BaseQuasarLxcImageBuild(sandbox_lxc_image.SandboxLxcImage):

    class Parameters(sandbox_lxc_image.SandboxLxcImage.Parameters):
        with sdk2.parameters.String(
            "Ubuntu release",
            default=sandbox_lxc_image.UbuntuRelease.BIONIC
        ) as ubuntu_release:
            for release in sandbox_lxc_image.UbuntuRelease:
                ubuntu_release.values[release] = release

        custom_image = sdk2.parameters.Bool("Create custom LXC image", default=True)
        test_result_lxc = sdk2.parameters.Bool("Test resulting container", default=True)
