#!/usr/bin/env sh

set -eu

# /bin/sh points to Dash by default, reconfigure to use bash
export DEBIAN_FRONTEND=noninteractive
echo "dash dash/sh boolean false" | debconf-set-selections
dpkg-reconfigure -p critical dash
dpkg --add-architecture i386

apt-get update
apt-get install --no-install-recommends -y \
    git \
    iptables \
    iptables-persistent

ip6tables --append OUTPUT ! --destination 2a02:6b8::/29 --jump DROP
ip6tables --list
ip6tables-save > /etc/iptables/rules.v6
