#!/usr/bin/env sh

set -eu

# /bin/sh points to Dash by default, reconfigure to use bash
export DEBIAN_FRONTEND=noninteractive
echo "dash dash/sh boolean false" | debconf-set-selections
dpkg-reconfigure -p critical dash
dpkg --add-architecture i386

apt-get update
apt-get install --no-install-recommends -y \
    git \
    net-tools=1.60+git20161116.90da8a0-1ubuntu1 \
    make=4.1-9.1ubuntu1 \
    gcc=4:7.4.0-1ubuntu2.3 \
    g++=4:7.4.0-1ubuntu2.3 \
    android-tools-mkbootimg=1:8.1.0+r23-5~18.04 \
    python=2.7.15~rc1-1 \
    python3-pip \
    python-crypto=2.6.1-8ubuntu2 \
    python3-setuptools=39.0.1-2 \
    libc6-dev \
    zip=3.0-11build1 \
    unzip=6.0-21ubuntu1.1 \
    bc=1.07.1-2 \
    rsync=3.1.2-2.1ubuntu1.1 \
    m4=1.4.18-1 \
    libgl1=1.0.0-2ubuntu2.3 \
    wget=1.19.4-1ubuntu2.2 \
    libc6:i386 \
    libstdc++6:i386 \
    iptables \
    iptables-persistent

pip3 install sympy==1.7.1
pip3 install pycryptodome==3.10.1

rm -rf /var/lib/apt/lists/*

git clone "https://gerrit.yandex-team.ru/gerrit/repo-tool" ./repo-tool
cp ./repo-tool/repo /usr/bin/
chmod a+x /usr/bin/repo

ip6tables --append OUTPUT ! --destination 2a02:6b8::/29 --jump DROP
ip6tables --list
ip6tables-save > /etc/iptables/rules.v6
