#!/usr/bin/env sh

set -eu

# /bin/sh points to Dash by default, reconfigure to use bash
export DEBIAN_FRONTEND=noninteractive
echo "dash dash/sh boolean false" | debconf-set-selections
dpkg-reconfigure -p critical dash
dpkg --add-architecture i386

### Update list of packages
apt-get update
apt-get install --no-install-recommends -y \
    build-essential  \
    wget  \
    unzip  \
    rsync  \
    bc  \
    git  \
    libc6:i386  \
    libstdc++6:i386  \
    zlib1g:i386 \
    iptables \
    iptables-persistent

### Repo tool installing
git clone "https://gerrit.yandex-team.ru/gerrit/repo-tool" ./repo-tool
cp ./repo-tool/repo /usr/bin/
chmod a+x /usr/bin/repo

ip6tables --append OUTPUT ! --destination 2a02:6b8::/29 --jump DROP
ip6tables --list
ip6tables-save > /etc/iptables/rules.v6
