
#
# Based on https://bb.yandex-team.ru/projects/QUAS/repos/amlandroid71/browse/build_all_ci.sh?at=refs%2Fheads%2FQUASAR-1831-module-android-7.1-build
#

set -eux

# 0. prepare env and install dependencies
export DEBIAN_FRONTEND=noninteractive
echo "dash dash/sh boolean false" | debconf-set-selections
dpkg-reconfigure -p critical dash
dpkg --add-architecture i386

apt-get update
apt-get install --no-install-recommends -y \
    git \
    net-tools \
    curl \
    make \
    gcc \
    g++ \
    android-tools-mkbootimg \
    python \
    python3-pip \
    python-crypto \
    python3-distutils \
    python3-setuptools \
    python3-venv \
    python3-crypto \
    libc6-dev \
    zip \
    unzip \
    bc \
    rsync \
    m4 \
    libgl1 \
    u-boot-tools \
    wget \
    libc6:i386 \
    libstdc++6:i386 \
    default-jre-headless \
    fuse \
    iptables \
    iptables-persistent

pip3 install sympy pyaxmlparser

rm -rf /var/lib/apt/lists/*

git clone "https://gerrit.yandex-team.ru/gerrit/repo-tool" ./repo-tool
cp ./repo-tool/repo /usr/bin/
chmod a+x /usr/bin/repo

# Permit only Yandex network
ip6tables -A INPUT -i lo -j ACCEPT
ip6tables -A OUTPUT -o lo -j ACCEPT
ip6tables --append OUTPUT ! --destination 2a02:6b8::/29 --jump DROP
ip6tables --list
ip6tables-save > /etc/iptables/rules.v6
