import sandbox.projects.quasar.lxc_image_builds.base as base_lxc_image_build
import sandbox.projects.quasar.platform as quasar_platform
import sandbox.projects.quasar.resource_types as quasar_resource_types
import sandbox.projects.sandbox.sandbox_lxc_image as sandbox_lxc_image
import sandbox.sdk2 as sdk2


class QuasarYandexstationLxcImageBuild(base_lxc_image_build.BaseQuasarLxcImageBuild):
    class Parameters(base_lxc_image_build.BaseQuasarLxcImageBuild.Parameters):
        custom_image = sdk2.parameters.Bool("Create custom LXC image",
                                            default=True)

        custom_script = sdk2.parameters.String(
            "Shell script to execute during final stage",
            description="Will be copied to /custom.sh inside container and"
                        " started with '/bin/bash /custom.sh' inside chroot."
                        " Stdout of script could be found in shell.log",
            multiline=True,
            default=base_lxc_image_build.read_custom_script(__file__)
        )
        resource_type = sdk2.parameters.String("Container resource type",
                                               default=quasar_resource_types.QuasarYandexstationLxcImage.name)
        resource_description = sdk2.parameters.String("Container resource's custom description",
                                                      default=base_lxc_image_build.DESCRIPTION_TEMPLATE.format(quasar_platform.Platform.YANDEXSTATION))

        with sdk2.parameters.String(
            "Ubuntu release",
            default=sandbox_lxc_image.UbuntuRelease.XENIAL
        ) as ubuntu_release:
            for release in sandbox_lxc_image.UbuntuRelease:
                ubuntu_release.values[release] = release
