#!/usr/bin/env sh

set -eux

# allow to run configures as root
# if not set, all may fail with "you should not run configure as root"
export FORCE_UNSAFE_CONFIGURE=1

# /bin/sh points to Dash by default, reconfigure to use bash
export DEBIAN_FRONTEND=noninteractive
echo "dash dash/sh boolean false" | debconf-set-selections
dpkg-reconfigure -p critical dash

apt-get update
apt-get install -y software-properties-common
add-apt-repository -y ppa:openjdk-r/ppa

apt-get update
apt-get install -y --force-yes \
    sudo \
    bash \
    busybox-static \
    cpio \
    fakeroot \
    gawk \
    xz-utils \
    yandex-jdk7 \
    python \
    git-core \
    gnupg \
    flex \
    bison \
    gperf \
    build-essential \
    zip \
    curl \
    zlib1g-dev \
    gcc-multilib \
    g++-multilib \
    libc6-dev-i386 \
    lib32ncurses5-dev \
    x11proto-core-dev \
    libx11-dev \
    lib32z-dev \
    ccache \
    libgl1-mesa-dev \
    libxml2-utils \
    xsltproc \
    unzip \
    mtools \
    u-boot-tools \
    htop \
    iotop \
    sysstat \
    iftop \
    pigz \
    bc \
    device-tree-compiler \
    lunzip \
    dosfstools \
    wget \
    libssl-dev \
    m4 \
    fuse \
    iptables \
    iptables-persistent

# Pretend to be legacy openjdk-7
mv /usr/lib/jvm/java-7-oracle /usr/lib/jvm/java-7-openjdk-amd64

wget https://proxy.sandbox.yandex-team.ru/2897994073 -O git-lfs-linux-amd64-2.3.4.tar.gz
tar xvzf git-lfs-linux-amd64-2.3.4.tar.gz
bash git-lfs-2.3.4/install.sh
git lfs uninstall

rm -rf /var/lib/apt/lists/*

# Permit only Yandex network
ip6tables -A INPUT -i lo -j ACCEPT
ip6tables -A OUTPUT -o lo -j ACCEPT
ip6tables --append OUTPUT ! --destination 2a02:6b8::/29 --jump DROP
ip6tables --list
ip6tables-save > /etc/iptables/rules.v6
