#!/usr/bin/env sh

set -eux

# /bin/sh points to Dash by default, reconfigure to use bash
export DEBIAN_FRONTEND=noninteractive
echo "dash dash/sh boolean false" | debconf-set-selections
dpkg-reconfigure -p critical dash
dpkg --add-architecture i386

apt-get update
apt-get install --no-install-recommends -y \
    git \
    net-tools \
    make \
    gcc \
    g++ \
    android-tools-mkbootimg \
    python \
    python3-pip \
    python-crypto \
    python3-setuptools \
    python3-crypto \
    libc6-dev \
    zip \
    unzip \
    bc \
    rsync \
    m4 \
    libgl1 \
    wget \
    libc6:i386 \
    libstdc++6:i386 \
    default-jre-headless \
    u-boot-tools \
    fuse \
    curl \
    iptables \
    iptables-persistent

pip3 install sympy

rm -rf /var/lib/apt/lists/*

git clone "https://gerrit.yandex-team.ru/gerrit/repo-tool" ./repo-tool
cp ./repo-tool/repo /usr/bin/
chmod a+x /usr/bin/repo

# Permit only Yandex network
ip6tables -A INPUT -i lo -j ACCEPT
ip6tables -A OUTPUT -o lo -j ACCEPT
ip6tables --append OUTPUT ! --destination 2a02:6b8::/29 --jump DROP
ip6tables --list
ip6tables-save > /etc/iptables/rules.v6
