import sandbox.common.enum as sb_enum


class Targets8Gb(sb_enum.Enum):
    GOYA43 = 'YANDEX_GOYA43.V430DJ1_CV9632-N55'
    GOYA50 = 'YANDEX_GOYA50.V500DJ7_CV9632-N55'
    UNIOTA = 'UNIOTA_GOYA'


class Targets16Gb(sb_enum.Enum):
    GOYA43 = 'YANDEX_GOYA43.16G.V430DJ1_CV9632-N55'
    GOYA50 = 'YANDEX_GOYA50.16G.V500DJ7_CV9632-N55'
    UNIOTA = 'UNIOTA_GOYA_16G'


target_configs = {
    Targets8Gb.GOYA43: {
        'target': 'YANDEX.GOYA43.V430DJ1Q01',
        'props': {
            'brand': 'YANDEX',
            'device': 'GOYA43.V430DJ1-Q01-C1',
        },
    },
    Targets8Gb.GOYA50: {
        'target': 'YANDEX.GOYA50.V500DJ7QE1',
        'props': {
            'brand': 'YANDEX',
            'device': 'GOYA50.V500DJ7-QE1-D5',
        },
    },
    Targets8Gb.UNIOTA: {
        'target': 'GOYA_UniOTA',
        'props': {
            'brand': 'UniOTA',
            'device': 'GOYA_UniOTA',
        },
        'uniota': True,
    },
    Targets16Gb.GOYA43: {
        'target': 'YANDEX.GOYA43.16G.V430DJ1Q01',
        'props': {
            'brand': 'YANDEX',
            'device': 'GOYA43.16G.V430DJ1-Q01-C1',
        },
    },
    Targets16Gb.GOYA50: {
        'target': 'YANDEX.GOYA50.16G.V500DJ7QE1',
        'props': {
            'brand': 'YANDEX',
            'device': 'GOYA50.16G.V500DJ7-QE1-D5',
        },
    },
    Targets16Gb.UNIOTA: {
        'target': 'GOYA_16G_UniOTA',
        'props': {
            'brand': 'UniOTA',
            'device': 'GOYA_16G_UniOTA',
        },
        'uniota': True,
    },
}
