# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from sandbox import common
from sandbox import sdk2
from sandbox.projects.saas.common.classes import SaasBinaryTask


class PoorManCauth(SaasBinaryTask):
    # upload to sandbox via ./poor_man_cauth upload --attr 'name=PoorManCauth' and release resource
    TASKS_RESOURCE_NAME = 'PoorManCauth'

    class Requirements(sdk2.Requirements):
        cores = 1  # vCores
        ram = 1024  # Mb
        disk_space = 2 * 1024

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        class Requirements(sdk2.Requirements):
            cores = 1  # vCores
            ram = 1024  # Mb
            disk_space = 2 * 1024

            class Caches(sdk2.Requirements.Caches):
                pass

        class Parameters(sdk2.Parameters):
            enable_yav = True

            abc_slug = sdk2.parameters.String('ABC group with allowed members',
                                              default_value="smart_devices_manufacturing")
            filter_key_id = sdk2.parameters.String('Select keys only with this description', default_value="")

            with sdk2.parameters.Group('YAV'):
                abc_secret_key = sdk2.parameters.String('Key containing Staff token',
                                                        default_value='robot-quasar-startrek-token')
                yav_staff_secret = sdk2.parameters.YavSecret('YAV secret with Staff tokens',
                                                             default='sec-01d2ffwrdbwyj37zkj4r8zegsn')  # robot-quasar
                ssh_secret_key = sdk2.parameters.String('Key to extract from YAV secret',
                                                        default_value='yandex.key-txt')
                yav_ssh_secret = sdk2.parameters.YavSecret('YAV secret with ssh key',
                                                           default='sec-01erq8dcwb1q2m72v7hk5whfwb')

            with sdk2.parameters.Group('SSH'):
                user = sdk2.parameters.String('SSH user', default='yandex')
                host = sdk2.parameters.String('SSH host', default='stand.dev.voicetech.yandex.net')
                port = sdk2.parameters.Integer('SSH port', default=10122)
                key_file_path = sdk2.parameters.String(
                    'Path to authorized_keys file on remote server (relative to $HOME)',
                    default=".ssh/yandex_authorized_keys")

    def on_execute(self):
        raise common.errors.TaskError('Task sources moved to /quasar/manufacturing/sandbox/poor_man_cauth')
