import json
import os

import sandbox.projects.common.arcadia.sdk as arc_sdk
import sandbox.projects.common.binary_task as binary_task
import sandbox.sdk2 as sdk2


class ReadJsonFromArcadia(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(binary_task.LastBinaryReleaseParameters):
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl('Url for arcadia', default=None)
        json_file_relative_path = sdk2.parameters.String('Json file relative path to export', required=True)
        with sdk2.parameters.Output:
            file_content = sdk2.parameters.JSON('Json file content')

    def on_execute(self):
        with arc_sdk.mount_arc_path(
            self.Parameters.checkout_arcadia_from_url, use_arc_instead_of_aapi=True
        ) as mount_path:
            with open(os.path.join(mount_path, self.Parameters.json_file_relative_path)) as json_file:
                self.Parameters.file_content = json.load(json_file)
