# -*- coding: utf-8 -*-
import sandbox.sdk2 as sdk2
import sandbox.projects.release_machine.components.all as rmc

from sandbox.projects.common import decorators
from sandbox.projects.release_machine.tasks.ReleaseMachineChangelog import ReleaseMachineChangelog


class QuasarReleaseMachineChangelog(ReleaseMachineChangelog):
    class Parameters(ReleaseMachineChangelog.Parameters):
        platform = sdk2.parameters.String('Platform')

    @decorators.memoized_property
    def c_info(self):
        component = rmc.get_component(self.Parameters.component_name)
        component.set_platform(self.Parameters.platform)
        return component
