import sandbox.projects.release_machine.components.job_graph.stages.job_graph_element as jg_element
import sandbox.projects.release_machine.components.job_graph.job_arrows as jg_arrows
import sandbox.projects.release_machine.components.job_graph.utils as jg_utils


class PlatformJobMixin(object):

    @staticmethod
    def get_job_type():
        raise NotImplementedError()

    @staticmethod
    def get_job_target():
        raise NotImplementedError()

    @classmethod
    def get_job_name_parameter(cls, platform, build_type=None, ya_build=False):
        modifiers = [platform, cls.get_job_target()]

        if build_type:
            modifiers.append(build_type)

        if ya_build:
            modifiers.append('ya')

        return '_'.join(modifiers)

    @classmethod
    def trigger(cls, platform, build_type=None, ya_build=False, parent_job_data=()):
        return jg_arrows.JobTrigger(
            job_type=cls.get_job_type(),
            job_name_parameter=cls.get_job_name_parameter(platform, build_type, ya_build),
            parent_job_data=parent_job_data,
        )


class JobRunTasklet(jg_element.JobGraphElement):

    @staticmethod
    def get_tasklet_name():
        raise NotImplementedError()

    def get_tasklet_input(self, **kwargs):
        tasklet_input = kwargs
        tasklet_input.update(self.extra_input)
        return tasklet_input

    def __init__(
            self,
            job_type,
            job_triggers,
            frequency=jg_utils.TestFrequency.LAZY,
            extra_input=None,
            job_params=None,
    ):
        self.extra_input = extra_input or {}

        merged_job_params = jg_utils.merge_job_params(
            job_params,
            dict(
                job_type=job_type,
                task_name='TASKLET_EXECUTOR',
                frequency=(frequency, None),
                should_add_to_db=jg_utils.should_add_to_db_branch,
                apiargs=dict(
                    hidden=False
                ),
                ctx=dict(
                    resource_owner='QUASAR',
                    resource_type='SANDBOX_TASKS_BINARY',
                    resource_attrs=dict(
                        default_tasklet_name=self.get_tasklet_name()
                    ),
                    tasklet_name=self.get_tasklet_name(),
                    yav_token_vault='QUASAR:robot-quasar-yav-token',
                ),
            )
        )

        super(JobRunTasklet, self).__init__(
            job_params=merged_job_params,
            job_arrows=(
                jg_arrows.ParentsData(
                    input_key='tasklet_input',
                    triggers=job_triggers,
                    transform=self.get_tasklet_input
                )
            )
        )


class JobRunPlatformTasklet(JobRunTasklet, PlatformJobMixin):

    def __init__(
            self,
            job_type,
            platform,
            job_triggers,
            build_type=None, ya_build=False,
            frequency=jg_utils.TestFrequency.LAZY,
            extra_input=None,
            job_params=None,
    ):
        self.extra_input = extra_input or {}

        merged_job_params = jg_utils.merge_job_params(
            job_params,
            dict(
                job_name_parameter=self.get_job_name_parameter(platform, build_type, ya_build),
            )
        )

        super(JobRunPlatformTasklet, self).__init__(
            job_type=job_type,
            job_triggers=job_triggers,
            frequency=frequency,
            extra_input=extra_input,
            job_params=merged_job_params,
        )
