from sandbox import sdk2
from sandbox.projects.quasar.platform import Platform
from sandbox.projects.quasar.resource_types import _QuasarOTABase, QuasarResourceBase
from sandbox.projects.quasar.users import system_images_releasers
from sandbox.sdk2.service_resources import LxcContainer


class QuasarServicesLxcImage(LxcContainer):
    """
    LXC image to run QUASAR_SERVICES_BUILD task

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha

    Use `services_build/lxc_image_create.sh` to create this image.
    """
    ttl = "inf"
    auto_backup = True
    releasable = True

    __default_attribute__ = sdk2.parameters.String


class QuasarImageBuildingLxcImage(LxcContainer):
    """
    LXC image to run image building tasks for Yandex.Module

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = system_images_releasers

    __default_attribute__ = sdk2.parameters.String


class QuasarStationMidiImageBuildingLxcImage(LxcContainer):
    """
    LXC image to run image building tasks for Yandex.Station Mini.

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = system_images_releasers

    __default_attribute__ = sdk2.parameters.String


class QuasarStationMiniImageBuildingLxcImage(LxcContainer):
    """
    LXC image to run image building tasks for Yandex.Station Mini.

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = system_images_releasers

    __default_attribute__ = sdk2.parameters.String


class QuasarStationMini2ImageBuildingLxcImage(LxcContainer):
    """
    LXC image to run image building tasks for Yandex.Station Mini 2.

    See https://wiki.yandex-team.ru/sandbox/cookbook/#use-custom-lxc-image
    """
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = system_images_releasers

    __default_attribute__ = sdk2.parameters.String


class QuasarStationMicroImageBuildingLxcImage(LxcContainer):
    """
    LXC image to run image building tasks for Yandex Micro

    See https://wiki.yandex-team.ru/sandbox/cookbook/#use-custom-lxc-image
    """
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = system_images_releasers

    __default_attribute__ = sdk2.parameters.String


class QuasarStationImageBuildingLxcImage(LxcContainer):
    """
    LXC image to run image building tasks for Yandex.Station.

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = system_images_releasers

    __default_attribute__ = sdk2.parameters.String


class QuasarStation2ImageBuildingLxcImage(LxcContainer):
    """
    LXC image to run image building tasks for Yandex.Station2.

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = system_images_releasers

    __default_attribute__ = sdk2.parameters.String


class QuasarImageAndroidCcache(sdk2.Resource):
    """
    NB: DEPRECATED, use `QuasarImageAndroidCcacheTarball` instead
    """
    ttl = 90
    auto_backup = True


class QuasarGradleCache(sdk2.Resource):
    """
    NB: DEPRECATED, use `QuasarGradleCacheTarball` instead
    """
    ttl = 90
    auto_backup = True


class QuasarDeviceImage(QuasarResourceBase):
    """
    A full image for quasar device redy to be flashed
    """
    buildtype = sdk2.parameters.String('BUILDTYPE for this image')
    version = sdk2.parameters.String('Full version of the software')
    signed = sdk2.parameters.Bool('If this image is production-signed')


class QuasarOTAImage(_QuasarOTABase):
    """
    An OTA-ready package with image
    """
    platform = sdk2.parameters.String('Quasar platform', default=Platform.YANDEXSTATION)


class QuasarImageTargetFiles(QuasarResourceBase):
    """
    A `target_files.zip` file from AOSP build process -- used in later stages
    """
    buildtype = sdk2.parameters.String('BUILDTYPE for this image')
    version = sdk2.parameters.String('Full version of the software')
    signed = sdk2.parameters.Bool('If this image is production-signed')


class QuasarModuleImage(QuasarResourceBase):
    """
    A full image for Yandex.Module redy to be flashed
    """
    buildtype = sdk2.parameters.String('BUILDTYPE for this image')
    version = sdk2.parameters.String('Full version of the software')
    signed = sdk2.parameters.Bool('If this image is production-signed')


class QuasarModuleOTAImage(_QuasarOTABase):
    """
    An OTA-ready package for Yandex.Module
    """
    platform = sdk2.parameters.String('Quasar platform', default="yandexmodule")


class QuasarModuleTargetFiles(QuasarResourceBase):
    """
    A `target_files.zip` file from AOSP build process -- used in later stages, for Yandex.Module
    """
    buildtype = sdk2.parameters.String('BUILDTYPE for this image')
    version = sdk2.parameters.String('Full version of the software')
    signed = sdk2.parameters.Bool('If this image is production-signed')


class QuasarStationMiniImage(QuasarResourceBase):
    """
    A full image for Yandex.Station Mini.
    """
    buildtype = sdk2.parameters.String('Build type for this image')
    version = sdk2.parameters.String('Full version of the software')
    signed = sdk2.parameters.Bool('If this image is signed')


class QuasarStationMiniOTAImage(_QuasarOTABase):
    """
    An OTA-ready package for YandexMini
    """
    platform = sdk2.parameters.String('Quasar platform', default=Platform.YANDEXMINI)


class QuasarStationMiniPackedOTAImage(_QuasarOTABase):
    """
    An Packed OTA-ready package for YandexMini
    """
    platform = sdk2.parameters.String('Quasar platform', default=Platform.YANDEXMINI)


class QuasarYandexminiPackedOTAImage(_QuasarOTABase):
    """
    An Packed OTA-ready package for YandexMini
    """
    platform = sdk2.parameters.String('Quasar platform', default=Platform.YANDEXMINI)


class QuasarJblImageBuildingLxcImage(LxcContainer):
    """
    LXC image to run image building tasks for JBL.
    """
    ttl = "inf"
    auto_backup = True
    releasable = True
    releasers = system_images_releasers

    __default_attribute__ = sdk2.parameters.String


class QuasarPlutoOTAImage(_QuasarOTABase):
    """
    An OTA-ready package for Yandex.Pluto
    """
    platform = sdk2.parameters.String('Quasar platform', default=Platform.PLUTO)
    factory = sdk2.parameters.Bool('If this image contains factory reset partition')
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')
    verbose_version = sdk2.parameters.String('A `str` version for this build')
