import sandbox.sdk2 as sdk2
import sandbox.projects.quasar.users as quasar_users
import sandbox.sdk2.service_resources as sb_service_resources
import sandbox.projects.quasar.platform as quasar_platform


class AndroidTvResourceBase(sdk2.Resource):
    ttl = 180
    auto_backup = True
    __default_attribute__ = sdk2.parameters.String


class AndroidTvTargetResourceBase(AndroidTvResourceBase):
    tv_target = sdk2.parameters.String('Tv target name')


class AndroidTvReleasableResourceBase(AndroidTvResourceBase):
    releasable = True


class AndroidTvImageBase(AndroidTvReleasableResourceBase):
    platform = None  # NB: children should declare platform property with sdk2 parameter with default value
    buildtype = sdk2.parameters.String('Image build type')
    version = sdk2.parameters.String('Build version, usually = build task id')
    verbose_version = sdk2.parameters.String('Dot separated version string')
    s3_url = sdk2.parameters.String('Url where this resource is published')
    quasmodrom_id = sdk2.parameters.String('Quasmodrom firmware id of image')
    crc32_checksum = sdk2.parameters.String('CRC32 checksum of this resource')
    supported_targets = sdk2.parameters.String('Supported targets tags')
    signed = sdk2.parameters.Bool('If this image is production-signed', default=None)
    major_release_num = sdk2.parameters.Integer('Major release number', default=None)
    minor_release_num = sdk2.parameters.Integer('Minor release number', default=None)
    image_type = sdk2.parameters.String('Image type', default='rom')


class AndroidTvOtaImageBase(AndroidTvImageBase):
    image_type = 'ota'


class AndroidTvTargetImageBase(AndroidTvImageBase):
    tv_target = sdk2.parameters.String('Tv target name')


class AndroidTvTargetOtaImageBase(AndroidTvOtaImageBase):
    tv_target = sdk2.parameters.String('Tv target name')


class AndroidTvUniotaImageBase(AndroidTvTargetImageBase):
    image_type = 'uniota'


class AndroidTvLxcContainer(sb_service_resources.LxcContainer):
    ttl = 60
    auto_backup = True
    releasable = True
    releasers = quasar_users.tv_releasers

    __default_attribute__ = sdk2.parameters.String


class AndroidTvReport(AndroidTvTargetResourceBase):
    platform = sdk2.parameters.String('Quasar platform')
    branch = sdk2.parameters.String('Manifest branch')


class AndroidTvMt9632CvImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_CV)


class AndroidTvMt9632CvOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_CV)


class AndroidTvMt9632CvUniotaImage(AndroidTvUniotaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_CV)


class AndroidTvGoyaImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.GOYA)


class AndroidTvGoyaOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.GOYA)


class AndroidTvGoyaUniotaImage(AndroidTvUniotaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.GOYA)


class AndroidTvMt9632CvteImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_CVTE)


class AndroidTvMt9632CvteOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_CVTE)


class AndroidTvMt9632CvteUniotaImage(AndroidTvUniotaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_CVTE)


class AndroidTvMt9632_11CvteImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_11_CVTE)


class AndroidTvMt9632_11CvteOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_11_CVTE)


class AndroidTvMt9632_11CvteUniotaImage(AndroidTvUniotaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9632_11_CVTE)


class AndroidTvMt6681CvImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT6681_CV)


class AndroidTvMt6681CvOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT6681_CV)


class AndroidTvMt6681CvUniotaImage(AndroidTvUniotaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT6681_CV)


class AndroidTvMt6681CvteImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT6681_CVTE)


class AndroidTvMt6681CvteOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT6681_CVTE)


class AndroidTvMt6681CvteUniotaImage(AndroidTvUniotaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT6681_CVTE)


class AndroidTvRt2842HikeenImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_RT2842_HIKEEN)


class AndroidTvRt2842HikeenOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_RT2842_HIKEEN)


class AndroidTvRt2871HikeenImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_RT2871_HIKEEN)


class AndroidTvRt2871HikeenOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_RT2871_HIKEEN)


class AndroidTvRt2861HikeenImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_RT2861_HIKEEN)


class AndroidTvRt2861HikeenOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_RT2861_HIKEEN)


class AndroidTvHisi351CvteImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_HISI351_CVTE)


class AndroidTvHisi351CvteOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_HISI351_CVTE)


class AndroidTvMt9256CvteImage(AndroidTvTargetImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9256_CVTE)


class AndroidTvMt9256CvteOtaImage(AndroidTvTargetOtaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9256_CVTE)


class AndroidTvMt9256CvteUniotaImage(AndroidTvUniotaImageBase):
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEX_TV_MT9256_CVTE)


class AndroidTvApp(AndroidTvReleasableResourceBase):
    pass


class AndroidTvAppResourceIdsConfig(AndroidTvReleasableResourceBase):
    platform = sdk2.parameters.String('Quasar platform', default='')


class AndroidTvAppSymbols(AndroidTvReleasableResourceBase):
    pass


# TV artifacts config
class AndroidTvArtifactsConfig(AndroidTvResourceBase):
    """
    Tv Apps artifacts YAML config
    """


class AndroidTvArtifacts(AndroidTvResourceBase):
    """
    Tv Apps artifacts
    """


# Yandex.Module2
# Full platform image.
class QuasarYandexmodule2Image(AndroidTvImageBase):
    """
    A full image for Yandex.Module2.
    """
    factory = sdk2.parameters.Bool('If this image contains factory reset partition')
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')
    hw_test_mode = sdk2.parameters.Bool(
        'If this image is for hardware-testing ONLY (NOT SUITABLE FOR PRODUCTION DEVICES), see QUASAR-7125')


# OTA image.
class QuasarYandexmodule2OTAImage(AndroidTvOtaImageBase):
    """
    An OTA-ready package for Yandex.Module2
    """
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.YANDEXMODULE_2)
    factory = sdk2.parameters.Bool('If this image contains factory reset partition')
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')


class QuasarYandexmodule2TargetFiles(AndroidTvImageBase):
    """
    A `target_files.zip` file from AOSP build process -- used in later stages, for Yandex.Module2
    """
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')
    repository_tag = sdk2.parameters.String('Repository tag')


# Yandex.Pluto
# Full platform image.
class AndroidTvPlutoImage(AndroidTvImageBase):
    """
    A full image for Yandex.Pluto.
    """
    factory = sdk2.parameters.Bool('If this image contains factory reset partition')
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')
    hw_test_mode = sdk2.parameters.Bool(
        'If this image is for hardware-testing ONLY (NOT SUITABLE FOR PRODUCTION DEVICES), see QUASAR-7125')


# OTA image.
class AndroidTvPlutoOtaImage(AndroidTvOtaImageBase):
    """
    An OTA-ready package for Yandex.Pluto
    """
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.PLUTO)
    factory = sdk2.parameters.Bool('If this image contains factory reset partition')
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')


class AndroidTvPlutoTargetFiles(AndroidTvImageBase):
    """
    A `target_files.zip` file from AOSP build process -- used in later stages, for Yandex.Pluto
    """
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')
    repository_tag = sdk2.parameters.String('Repository tag')


# Yandex.Magritte
# Full platform image.
class AndroidTvMagritteImage(AndroidTvImageBase):
    """
    A full image for Yandex.Magritte.
    """
    factory = sdk2.parameters.Bool('If this image contains factory reset partition')
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')
    hw_test_mode = sdk2.parameters.Bool(
        'If this image is for hardware-testing ONLY (NOT SUITABLE FOR PRODUCTION DEVICES), see QUASARSYS-550')


# OTA image.
class AndroidTvMagritteOtaImage(AndroidTvOtaImageBase):
    """
    An OTA-ready package for Yandex.Magritte
    """
    platform = sdk2.parameters.String('Quasar platform', default=quasar_platform.Platform.MAGRITTE)
    factory = sdk2.parameters.Bool('If this image contains factory reset partition')
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')


class AndroidTvMagritteTargetFiles(AndroidTvImageBase):
    """
    A `target_files.zip` file from AOSP build process -- used in later stages, for Yandex.Magritte
    """
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')
    repository_tag = sdk2.parameters.String('Repository tag')


class QuasarYandexmodule2LxcImage(AndroidTvLxcContainer):
    """
    LXC image to run image building tasks for Yandexmodule2.

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """


class AndroidTvPlutoLxcImage(AndroidTvLxcContainer):
    """
    LXC image to run image building tasks for Pluto.

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """


class QuasarYandexmodule2LinuxImage(AndroidTvReleasableResourceBase):
    """
    A buildroot-based Linux image for yandexmodule_2 sideload in factory mode

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')


class AndroidTvPlutoLinuxImage(AndroidTvReleasableResourceBase):
    """
    A buildroot-based Linux image for pluto sideload in factory mode

    See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
    """
    secureboot = sdk2.parameters.Bool('If this image is secureboot-locked for production')
