import logging

from sandbox import sdk2

from sandbox.common.types.misc import DnsType

from sandbox.projects.quasar.utils import SafePublishingMixing, SignerMixin


class QuasarSignerSign(SignerMixin, SafePublishingMixing, sdk2.Task):
    """
    Sign some artifact (image / script / etc) as a part of build process. -- just testing for now
    """

    class Parameters(sdk2.Task.Parameters):
        test = sdk2.parameters.Bool('Test', default=False)
        source = sdk2.parameters.Resource('Resource to sign')

        with sdk2.parameters.String('Signer cert id', required=True) as cert_id:
            for (cert_name, cert) in SignerMixin.Certs.named_all():
                cert_id.values[cert_name] = cert_name

        with sdk2.parameters.String('Result resource type', required=True) as result_resource_type:
            for resource_type in list(sdk2.Resource):
                if 'QUASAR' in str(resource_type).upper():  # TODO: a better type narrowing
                    result_resource_type.values[resource_type.name] = resource_type.name

    class Requirements(sdk2.Task.Requirements):
        cores = 1  # we are light task, only call other tasks
        dns = DnsType.DNS64  # for external interactions
        disk_space = 20 * 1024  # 20 Gb for artifacts
        environments = [] + SignerMixin.environments  # as required by SignerMixin

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        signed = self.sign(sdk2.ResourceData(self.Parameters.source).path, SignerMixin.Certs.for_name(self.Parameters.cert_id))

        logging.info('Publishing...')

        self.publish_safely(resources={sdk2.Resource[self.Parameters.result_resource_type]: signed}, comment='signed result')

        logging.info('Done')
