"""
Task unpacking Yandex Station 2 aml.img
"""
from sandbox import sdk2
from sandbox.common import errors
import sandbox.common.types.client as ctc
from sandbox.projects.saas.common.classes import SaasBinaryTask
from sandbox.projects.quasar.resource_types import QuasarYandexstation2Image


class Station2ImageUnpack(SaasBinaryTask):
    TASKS_RESOURCE_NAME = "Station2ImageUnpack"

    # upload to sandbox via ./station2_image_unpack upload --attr 'name=Station2ImageUnpack'
    # and release resource
    class Requirements(sdk2.Requirements):
        cores = 2  # vCores
        ram = 2048  # Mb
        disk_space = 15 * 1024
        client_tags = ctc.Tag.PORTOD
        porto_layers = [3016287278]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        abc_slug = sdk2.parameters.String(
            "ABC group with allowed members", default_value="smart_devices_manufacturing"
        )
        resource_amlogic_binary = sdk2.parameters.Resource(
            "Amlogic binary resource id", default_value=2946280182
        )
        resource_aml_img = sdk2.parameters.LastReleasedResource(
            "Station 2 aml image resource id",
            resource_type=QuasarYandexstation2Image,
            required=True,
        )
        arc_repack_path = sdk2.parameters.ArcadiaUrl(
            "Arcadia repack script and data",
            default_value="arcadia:/arc/trunk/arcadia/quasar/manufacturing/burn_station/station2fw",
        )

    def on_execute(self):
        raise errors.TaskError('Task sources moved to /quasar/manufacturing/sandbox/station2_image_unpack')
