#!/usr/bin/env bash	set -o errexit
set -o xtrace

#
# This script is intended to be run to create LXC container to run the task
# See https://wiki.yandex-team.ru/sandbox/cookbook/#sborkakontejjnerasokruzheniemvkotorombudetispolnjatsjazadacha
# Loosely based on ./maps/mapsandroid/container_creation.sh
#
# Installs java-8, protoc-3 and android sdk with basic tools
# Install android ndk-14 to build services (and puts it path to env NDK_14_TOOLCHAIN).
# Stores env in `/etc/profile` to be read by the task
#
# Task to build is SANDBOX_LXC_IMAGE
#
# Non-default parameters:
#
#   Ubuntu release:
#       xenial
#
#   Container resource type:
#       QUASAR_SERVICES_LXC_IMAGE
#
#   Shell script to execute during final stage:
#       <contents of this script>

# REPOS
apt-get install -y software-properties-common python-software-properties

# TODO not the best source for protoc, use yandex repos!
add-apt-repository -y ppa:maarten-fonville/protobuf

add-apt-repository -y "deb http://common.dist.yandex.ru/common stable/amd64/"
add-apt-repository -y "deb http://common.dist.yandex.ru/common stable/all/"
apt-get update -y

# DEPS
apt-get install -y --force-yes yandex-jdk8 build-essential curl unzip protobuf-compiler python python-pip git cmake

# ANDROID:
curl --verbose --insecure -o sdk-tools.zip https://dl.google.com/android/repository/sdk-tools-linux-3859397.zip
mkdir -p /usr/local/android-sdk-linux
unzip sdk-tools.zip -d /usr/local/android-sdk-linux
rm sdk-tools.zip

tee /etc/profile.d/66-android.sh << "EOF"
export ANDROID_HOME=/usr/local/android-sdk-linux
export PATH=$ANDROID_HOME/platform-tools:$ANDROID_HOME/tools:$ANDROID_HOME/tools/bin:$PATH
EOF

tee /etc/profile.d/55-java.sh << "EOF"
export JAVA_HOME=/usr/local/java8
export JAVA_TOOL_OPTIONS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
EOF

. /etc/profile

yes | sdkmanager --licenses

sdkmanager "tools" "platform-tools" "build-tools;26.0.2" "build-tools;25.0.3" "platforms;android-25" "platforms;android-26" "platforms;android-27" "ndk-bundle"

# NDK_14
# see https://github.yandex-team.ru/quasar-dev/quasar/blob/f7aa7f0870770c351e16d942adca7a2eecc8fd5e/daemons/README.md#building
export API_LEVEL=23
export NDKDIR=/usr/local/android-ndk-14
export TOOLCHAINDIR_64=/usr/local/android-ndk-14-toolchain64/
export TOOLCHAINDIR_32=/usr/local/android-ndk-14-toolchain32/

mkdir -p ${NDKDIR}

curl --verbose --insecure -o ndk_14.zip https://dl.google.com/android/repository/android-ndk-r14b-linux-x86_64.zip
mv ndk_14.zip ${NDKDIR}
cd ${NDKDIR} && unzip ndk_14.zip && rm ndk_14.zip
cd android-ndk-r14b

build/tools/make_standalone_toolchain.py --arch arm64 --api ${API_LEVEL} --install-dir ${TOOLCHAINDIR_64}
rm ${TOOLCHAINDIR_64}/aarch64-linux-android/lib/libstdc++.a

build/tools/make_standalone_toolchain.py --arch arm --api ${API_LEVEL} --install-dir ${TOOLCHAINDIR_32}
rm ${TOOLCHAINDIR_32}/arm-linux-androideabi/lib/libstdc++.a

tee /etc/profile.d/77-ndk-14.sh << EOF
export NDK_14_TOOLCHAIN="${TOOLCHAINDIR_64}"
export NDK_14_TOOLCHAIN_64="${TOOLCHAINDIR_64}"
export NDK_14_TOOLCHAIN_32="${TOOLCHAINDIR_32}"
EOF

# SIGNER
# TODO: change to released version from pypi.yandex-team.ru when SIGNER-84 is merged and released!
pip install git+https://github.yandex-team.ru/idm/yandex-signer-client.git@3852f7c7561bc0c4a9a7d9755456a7cdbc31d1db
# test it:
ya-signer --help
