import logging

import sandbox.projects.common.binary_task as binary_task
import sandbox.sdk2 as sdk2

from os.path import join as pj
import os
import zlib


class QuasarUploadSymbols(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(binary_task.LastBinaryReleaseParameters):

        source = sdk2.parameters.Resource('Resource with daemons')
        version = sdk2.parameters.String('Symbols version')
        table_path = sdk2.parameters.String('YT dynamic table path to which symbols will be uploaded')
        cluster_name = sdk2.parameters.String('YT cluster name', default='hahn')
        robot_secret = sdk2.parameters.String('Yav robot-quasar secret', default='sec-01d2ffwrdbwyj37zkj4r8zegsn')
        robot_secrets_version = sdk2.parameters.String('Yav robot-quasar secret version',
                                                       default='ver-01f4crjmcp6atevs8s61emzvn8')
        yt_token_vault = sdk2.parameters.String('YT token vault', default='robot-quasar-yt-token')

    def upload_symbol(self, client, table_path, symbol_data, module_name, debug_id):
        logging.info("Uploading %s %s")
        client.insert_rows(
            table_path, [{
                "debug_identifier": debug_id,
                "module": module_name,
                "symbols": symbol_data
            }],
        )

    def upload_symbols(self, symbols_path, client, table_path):
        for module_name in os.listdir(symbols_path):
            module_dir = pj(symbols_path, module_name)
            for debug_id in os.listdir(module_dir):
                debug_id_dir = pj(module_dir, debug_id)
                for symbol_file in os.listdir(debug_id_dir):
                    if symbol_file.endswith(".sym"):
                        symbol_path = pj(debug_id_dir, symbol_file)
                        with open(symbol_path, mode='rb') as symbol_data:
                            symbol_compressed = zlib.compress(symbol_data.read())
                            self.upload_symbol(client, table_path, symbol_compressed, module_name, debug_id)
                            break

    def on_execute(self):
        from yt.wrapper import YtClient

        daemons_path = sdk2.ResourceData(self.Parameters.source).path
        symbols_path = pj(str(daemons_path), 'breakpad_symbols')

        robot_secrets = sdk2.yav.Secret(self.Parameters.robot_secret, self.Parameters.robot_secrets_version)
        yt_token = robot_secrets.data()[self.Parameters.yt_token_vault]
        client = YtClient(self.Parameters.cluster_name, yt_token)
        self.upload_symbols(symbols_path, client, self.Parameters.table_path)
