from abc import ABCMeta


class _UsersGroup(object):
    __metaclass__ = ABCMeta

    def __init__(self, usernames):
        self._staff_usernames = set(usernames)

    @property
    def devs(self):
        return self._staff_usernames


class QuasarSystemHardwareDevelopers(_UsersGroup):
    def __init__(self):
        super(QuasarSystemHardwareDevelopers, self).__init__([
            "krautcat",
            "hosstia",
            "lungu",
            "m-a-d",
            "bobrofon",
            "mvanchugov",
            "kravserg",
        ])


class QuasarYandexIoDevelopers(_UsersGroup):
    def __init__(self):
        super(QuasarYandexIoDevelopers, self).__init__([
            "grmammaev",
            "vreutov",
            "labudidabudai",
            "vasko",
            "dmitrii-ut",
            "deshevoy",
        ])


class QuasarStationDevelopers(_UsersGroup):
    def __init__(self):
        super(QuasarStationDevelopers, self).__init__([
            "pupssman",
            "solovyev",
            "prokudinalex"
        ])


class QuasarIotInfrastructureDevelopers(_UsersGroup):
    def __init__(self):
        super(QuasarIotInfrastructureDevelopers, self).__init__([
            "mkhardin",
        ])


def _create_releasers_list(*devclasses):
    _helper_set = set()

    for devclass in devclasses:
        _helper_set |= devclass.devs

    return list(_helper_set)


system_images_releasers = _create_releasers_list(
    QuasarSystemHardwareDevelopers(),
    QuasarStationDevelopers(),
    QuasarYandexIoDevelopers()
)

tv_releasers = [
    "grmammaev",
    "belenkom",
    "e-galkin",
    "dhabensky",
    "aigoncharenko",
]
