import sandbox.sandboxsdk.parameters as sb_params

from sandbox import sdk2
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.resource_types import nanny_releasers
from sandbox.sandboxsdk import paths


class VersionParameter(sb_params.SandboxStringParameter):
    name = 'version'
    description = 'Version'
    required = True


class VMAGENT_PACK(sdk2.Resource):
    auto_backup = True
    releasable = True
    executable = False
    releasers = nanny_releasers + ['max7255']


class BuildVmagent(YaMakeTask):
    type = 'BUILD_VMAGENT'
    NEW_PACK_DIR = 'vmagent'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.TestParameter,
        build_params.TestTag,
        VersionParameter,
    ]

    def post_build(self, source_dir, output_dir, pack_dir):
        paths.copy_path(pack_dir, self.NEW_PACK_DIR)
        version = self.ctx['version']
        self.create_resource(
            description='Vmagent {}'.format(version),
            resource_type=VMAGENT_PACK,
            resource_path=self.NEW_PACK_DIR,
            arch='linux',
            attributes={
                'version': version
            }
        )

    def get_targets(self):
        return ['infra/vmagent']

    def get_arts(self):
        return [
            {
                'path': 'infra/vmagent/bin/vmagent/vmagent',
            },
            {
                'path': 'infra/vmagent/bin/vmctl/vmctl',
            },
        ]

    def get_arts_source(self):
        return [
            {
                'path': 'infra/vmagent/src/vmagent/scripts',
            }
        ]

    def get_env_vars(self):
        env_vars = YaMakeTask.get_env_vars(self)
        env_vars['VMAGENT_SECRET'] = self.deref('$(vault:value:NANNY:RTC_VMAGENT_SECRET)')
        env_vars['SANDBOX_TOKEN'] = self.deref('$(vault:value:NANNY:VMAGENT_SANDBOX_TOKEN)')
        return env_vars


__Task__ = BuildVmagent
