import os
import sandbox.sandboxsdk.parameters as sb_params

from sandbox import sdk2
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.resource_types import nanny_releasers
from sandbox.sandboxsdk import paths


class VersionParameter(sb_params.SandboxStringParameter):
    name = 'version'
    description = 'Version'
    required = True


class VMAGENT_PACK_V2(sdk2.Resource):
    auto_backup = True
    releasable = True
    executable = False
    releasers = nanny_releasers + ['max7255', 'warwish']


class BuildVmagent(YaMakeTask):
    type = 'BUILD_VMAGENT_V2'
    NEW_PACK_DIR = 'vmagent'
    VMAGENT_CONFIG_PY_PATH = 'infra/qyp/vmagent/src/config.py'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.TestParameter,
        build_params.TestTag,
        build_params.UseArcadiaApiFuse,
        build_params.AllowArcadiaApiFallback,
        build_params.TargetPlatform,
        build_params.TargetPlatformFlags,
        VersionParameter,
    ]

    def pre_build(self, source_dir):
        version = self.ctx['version']
        config_path = os.path.join(source_dir, self.VMAGENT_CONFIG_PY_PATH)
        with open(config_path) as fp:
            config_data = fp.read()
        new_config_data = config_data.replace('___VMAGENT_VERSION___', version)
        with open(config_path, "w") as fp:
            fp.write(new_config_data)

    def post_build(self, source_dir, output_dir, pack_dir):
        paths.copy_path(pack_dir, self.NEW_PACK_DIR)
        paths.add_executable_permissions_for_path(self.NEW_PACK_DIR, recursively=True)
        version = self.ctx['version']
        self.create_resource(
            description='Vmagent {}'.format(version),
            resource_type=VMAGENT_PACK_V2,
            resource_path=self.NEW_PACK_DIR,
            arch='linux',
            attributes={
                'version': version
            }
        )

    def get_targets(self):
        return ['infra/qyp/vmagent']

    def get_arts(self):
        return [
            {
                'path': 'infra/qyp/vmagent/bin/vmagent/vmagent',
            },
        ]

    def get_arts_source(self):
        return [
            {
                'path': 'infra/qyp/vmagent/src/scripts',
            }
        ]

    def get_env_vars(self):
        env_vars = YaMakeTask.get_env_vars(self)
        env_vars['VMAGENT_SECRET'] = self.deref('$(vault:value:NANNY:RTC_VMAGENT_SECRET)')
        env_vars['SANDBOX_TOKEN'] = self.deref('$(vault:value:NANNY:VMAGENT_SANDBOX_TOKEN)')
        return env_vars


__Task__ = BuildVmagent
