import os

from sandbox import sdk2
from sandbox.sandboxsdk.copy import RemoteCopy


class CopyVmImage(sdk2.Task):
    class Parameters(sdk2.Parameters):
        image_url = sdk2.parameters.String('Qemu image url', required=True)

    def on_execute(self):
        image_path = str(self.path('image'))
        RemoteCopy(self.Parameters.image_url, image_path)(timeout=self.Parameters.kill_timeout)
        image_path = "/".join([image_path, os.listdir(image_path)[0]])
        qemu_image = sdk2.Resource['OTHER_RESOURCE'](self, 'Qemu Image', image_path)
        sdk2.ResourceData(qemu_image).ready()
