import os

from sandbox.common.types.client import Tag
from sandbox import sdk2
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox.sandboxsdk.process import run_process


class QemuMergedImage(sdk2.Resource):
    auto_backup = True


class MergeQemuImage(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        privileged = True
        client_tags = Tag.Group.LINUX

    class Parameters(sdk2.Parameters):
        image_url = sdk2.parameters.String('Qemu image url', required=True)
        delta_url = sdk2.parameters.String('Qemu delta url', required=True)

    def on_execute(self):
        run_process(['sudo', 'apt-get', 'update'], log_prefix='apt')
        run_process(['sudo', 'apt-get', 'install', '--yes', 'qemu-static'], log_prefix='apt')
        bin_path = sdk2.paths.which("qemu-img")
        image_path = str(self.path('image'))
        delta_path = str(self.path('delta'))
        RemoteCopy(self.Parameters.image_url, image_path)(timeout=self.Parameters.kill_timeout)
        RemoteCopy(self.Parameters.delta_url, delta_path)(timeout=self.Parameters.kill_timeout)
        image_path = "/".join([image_path, os.listdir(image_path)[0]])
        delta_path = "/".join([delta_path, os.listdir(delta_path)[0]])
        run_process([bin_path, 'rebase', '-u', '-b', image_path, delta_path], log_prefix='qemu-img')
        run_process([bin_path, 'commit', delta_path], log_prefix='qemu-img')
        qemu_image = QemuMergedImage(self, 'Qemu Image', image_path)
        sdk2.ResourceData(qemu_image).ready()
