# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

from sandbox import sdk2
from sandbox.projects.rasp.utils.email_notifications import (
    EmailNotificationMixin,
    use_email_notification_params,
    TRAIN_GROUP,
)

FILE_NAMES = ['im84', 'return_policy_accident']
SUFFIXES = ['url', 'size', 'last_modified']


class RaspCheckFilesTask(sdk2.Task, EmailNotificationMixin):
    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('im84') as im84:
            im84_url = sdk2.parameters.String('Url', required=True)
            im84_size = sdk2.parameters.Integer('Content-length', required=True)
            im84_last_modified = sdk2.parameters.String('Last-Modified', required=False, default='')

        with sdk2.parameters.Group('return_policy_accident') as return_policy_accident:
            return_policy_accident_url = sdk2.parameters.String('Url', required=True)
            return_policy_accident_size = sdk2.parameters.Integer('Content-length', required=True)
            return_policy_accident_last_modified = sdk2.parameters.String('Last-Modified', required=False, default='')

        _email_notification_params = use_email_notification_params()

    def on_execute(self):
        from travel.rasp.scripts.files_check.lib.check import check_file, RaspFileChangedException

        files = {
            file_name: list(str(getattr(self.Parameters, file_name + '_' + suffix)) for suffix in SUFFIXES)
            for file_name in FILE_NAMES
        }

        changed = [name for name, args in files.items() if check_file(*args)]
        if changed:
            raise RaspFileChangedException(', '.join(changed) + ' changed')

    def on_save(self):
        super(RaspCheckFilesTask, self).on_save()
        self.add_email_notifications(notifications_group=TRAIN_GROUP)
