# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from sandbox import sdk2
from sandbox.projects.common.binary_task import LastBinaryTaskRelease, binary_release_parameters

from sandbox.projects.rasp.utils.email_notifications import (
    EmailNotificationMixin,
    use_email_notification_params,
    BUS_GROUP,
)
from sandbox.projects.rasp.utils.juggler import JugglerNotificationMixin, use_juggler_notification_params
from sandbox.projects.rasp.utils.rasp_scripts import RaspScriptsTask, use_rasp_scripts_params
from sandbox.projects.rasp.utils.solomon import SolomonProgressMixin


class TrainsDumpActualDirections(
    sdk2.Task,
    RaspScriptsTask,
    LastBinaryTaskRelease,
    SolomonProgressMixin,
    JugglerNotificationMixin,
    EmailNotificationMixin,
):
    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 1 * 1024

        class Caches(sdk2.Requirements.Caches):  # https://wiki.yandex-team.ru/sandbox/clients/#client-tags-multislot
            pass  # task does not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 60 * 15
        ext_params = binary_release_parameters(stable=True)

        _rasp_scripts_params = use_rasp_scripts_params()
        _email_notification_params = use_email_notification_params()
        _juggler_notification_params = use_juggler_notification_params()

    def set_task_environ(self):
        os.environ['DJANGO_SETTINGS_MODULE'] = 'travel.rasp.trains.scripts.dump_actual_directions.settings'

    def on_save(self):
        LastBinaryTaskRelease.on_save(self)

        self.add_juggler_notifications(environment=self.Parameters.env_type)
        self.add_email_notifications(notifications_group=BUS_GROUP)

    def on_execute(self):
        LastBinaryTaskRelease.on_execute(self)

        self.set_common_environ()

        from travel.rasp.trains.scripts.dump_actual_directions.dump_actual_directions import dump_actual_directions

        with self.report_progress('trains_dump_actual_directions', self.Parameters.env_type):
            dump_actual_directions()
