# -*- coding: utf-8 -*-

from datetime import date, datetime

import sandbox.common.types.client as ctc
from sandbox import sdk2
from sandbox.projects.rasp.utils import ISO_FORMAT
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params


class RaspBlaBlaCarReport(sdk2.Task, EmailNotificationMixin):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.LXC
        ram = 2 * 1024
        tasks_resource = sdk2.Task.Requirements.tasks_resource(default=919148818)

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Blablacar report params') as blablacar_report_params:
            tmp_file = sdk2.parameters.String('tmp file', default='tmp/tmp_file.xlsx', required=True)
            to_emails = sdk2.parameters.List('to emails', default=['corroder@yandex-team.ru'], required=True)
            cc_emails = sdk2.parameters.List('cc emails', default=[], required=True)
            clickhouse_user_vault_name = sdk2.parameters.String('Clickhouse user vault name', required=True)
            clickhouse_password_vault_name = sdk2.parameters.String('Clickhouse pass vault name', required=True)
            date = sdk2.parameters.String('ISO datetime (default=now)', required=False, default='')

        _email_notification_params = use_email_notification_params()

    def on_execute(self):
        now = date.today()
        if self.Parameters.date:
            now = datetime.strptime(self.Parameters.date, ISO_FORMAT).date()
        if now.day == 1 or now.isoweekday() == 1:
            from travel.rasp.analytics.blablacar_report.lib.report import do_report_send
            click_pass = sdk2.Vault.data(self.Parameters.clickhouse_password_vault_name)
            do_report_send(self.Parameters.tmp_file, self.Parameters.to_emails, self.Parameters.cc_emails,
                           self.Parameters.clickhouse_user_vault_name, click_pass, today=now)

    def on_save(self):
        super(RaspBlaBlaCarReport, self).on_save()
        self.add_email_notifications()
