# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import datetime
import logging
from os import environ

import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.projects.rasp.bus.BusBaseTask import BusBaseTaskAutoResource, BusAutoResourceParameters


class BusCarrierMatcher(BusBaseTaskAutoResource):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024
        ram = 2048
        dns = ctm.DnsType.DNS64

    class Parameters(BusAutoResourceParameters):
        with sdk2.parameters.Group("Carrier Matcher") as params:
            dry = sdk2.parameters.Bool('Dry', default=True, required=True)
            yt_proxy = sdk2.parameters.String("YT proxy", required=True, default="hahn")
            yql_token = sdk2.parameters.String("YQL token", required=True,
                                               default="sec-01d956rm0wknnrbhhjsyx0rh56.sputnik-yql-token")
            suppliers = sdk2.parameters.List('Suppliers (all if empty)', default=[], required=True)
            interval_end_date = sdk2.parameters.String("Date of search interval end, NOT today, YYYY-MM-DD, "
                                                       "yesterday if empty")
            days_interval = sdk2.parameters.Integer("Search interval length, days", required=True, default=3)

    def on_execute(self):
        super(BusCarrierMatcher, self).on_execute()
        if self.Parameters.interval_end_date:
            interval_end_date = datetime.datetime.strptime(self.Parameters.interval_end_date, '%Y-%m-%d')
        else:
            interval_end_date = datetime.datetime.utcnow() - datetime.timedelta(days=1)
        environ['YENV_TYPE'] = self.Parameters.environment
        environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')
        from travel.rasp.bus.scripts.carrier_matcher import CarrierMatcher

        carrier_matcher = CarrierMatcher(
            self.Parameters.yt_proxy,
            self.Parameters.yql_token,
            self.Parameters.suppliers,
            interval_end_date,
            self.Parameters.days_interval,
            self.Parameters.dry
        )
        carrier_matcher.run()

        logging.info("Done!")
