# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from os import environ

from sandbox import sdk2
from sandbox.projects.rasp.bus.BusBaseTask import BusBaseTaskAutoResource, BusAutoResourceParameters
from sandbox.sdk2 import yav


class BusEndpointsStats(BusBaseTaskAutoResource):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024
        ram = 2048

    class Parameters(BusAutoResourceParameters):
        yt_secret = sdk2.parameters.String("YT sputnik secret", required=True, default="sec-01d956rm0wknnrbhhjsyx0rh56")
        yt_secret_key = sdk2.parameters.String("YT sputnik key", required=True, default="sputnik-yt-token")

    def on_execute(self):
        super(BusEndpointsStats, self).on_execute()

        environ['YENV_TYPE'] = self.Parameters.environment
        environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')

        from travel.rasp.bus.scripts.endpoints_stats import EndpointsStatistic

        secret_data = yav.Secret(self.Parameters.yt_secret).data()
        yt_token = secret_data[self.Parameters.yt_secret_key]

        endpoint_stats = EndpointsStatistic(
            yt_token,
            self.Parameters.environment,
        )
        endpoint_stats.run()

        logging.info("Done!")
