# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from os import environ

from sandbox import sdk2
from sandbox.projects.rasp.bus.BusBaseTask import BusBaseTaskAutoResource, BusAutoResourceParameters


class BusFeedsUpdater(BusBaseTaskAutoResource):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024
        ram = 2048

    class Parameters(BusAutoResourceParameters):
        days_count = sdk2.parameters.Integer('Count of previous days for CPA statistics', required=True, default=30)
        orders_threshold = sdk2.parameters.Integer('Minimal orders count for direction', required=True, default=3)
        default_settlement_image = sdk2.parameters.String('Destination image if it is missing in region_images')
        limit = sdk2.parameters.Integer('Directions count limit', required=True, default=10000)

    def on_execute(self):
        super(BusFeedsUpdater, self).on_execute()

        environ['YENV_TYPE'] = self.Parameters.environment
        environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')

        from travel.rasp.bus.scripts.feeds_updater import FeedsUpdater
        feeds_updater = FeedsUpdater(
            self.Parameters.days_count,
            self.Parameters.orders_threshold,
            self.Parameters.limit,
            self.Parameters.default_settlement_image,
        )
        feeds_updater.run()

        logging.info('Successfully done')
