# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from sandbox import sdk2
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params


class BusResetSearchResultCacheByParticularDirection(sdk2.Task, EmailNotificationMixin):
    class Requirements(sdk2.Task.Requirements):
        ram = 1024
        tasks_resource = sdk2.Task.Requirements.tasks_resource(default=1208138380)

    class Parameters(sdk2.Task.Parameters):
        supplier = sdk2.parameters.String('Supplier', default='noy', required=True)
        from_point = sdk2.parameters.String('Departure', default='c213', required=True)
        to_point = sdk2.parameters.String('Arrival', default='c2', required=True)
        when = sdk2.parameters.String('When', default='1991-06-24', required=True)
        dry = sdk2.parameters.Bool('Dry', default=True, required=True)
        environment = sdk2.parameters.String('Environment', default='testing', required=True)

        _email_notification_params = use_email_notification_params()

    def on_execute(self):
        os.environ['YENV_TYPE'] = self.Parameters.environment
        os.environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')

        from travel.rasp.bus.scripts.cache_reseter.cache_reseter import cache_reseter

        cache_reseter.reset_search_data(
            supplier=self.Parameters.supplier,
            from_point=self.Parameters.from_point,
            to_point=self.Parameters.to_point,
            when=self.Parameters.when,
            dry=self.Parameters.dry,
        )

    def on_save(self):
        super(BusResetSearchResultCacheByParticularDirection, self).on_save()
        self.add_email_notifications()
