# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from sandbox import sdk2
from sandbox.projects.rasp.utils.email_notifications import EmailNotificationMixin, use_email_notification_params


class BusResetSegmentCache(sdk2.Task, EmailNotificationMixin):
    class Requirements(sdk2.Task.Requirements):
        ram = 1024
        tasks_resource = sdk2.Task.Requirements.tasks_resource(default=1208140862)

    class Parameters(sdk2.Task.Parameters):
        suppliers = sdk2.parameters.List('Suppliers', default=[], required=True)
        dry = sdk2.parameters.Bool('Dry', default=True, required=True)
        environment = sdk2.parameters.String('Environment', default='testing', required=True)

        _email_notification_params = use_email_notification_params()

    def on_execute(self):
        os.environ['YENV_TYPE'] = self.Parameters.environment
        os.environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')

        from travel.rasp.bus.scripts.cache_reseter.cache_reseter import cache_reseter

        cache_reseter.reset_segments_for(
            suppliers=self.Parameters.suppliers,
            dry=self.Parameters.dry,
        )

    def on_save(self):
        super(BusResetSegmentCache, self).on_save()
        self.add_email_notifications()
