# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from os import environ, path as os_path
from pathlib2 import Path
from shutil import copy

from sandbox import sdk2
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToNannyAndYaDeployTask2
from sandbox.projects.rasp.bus.BusBaseTask import BusBaseTaskAutoResource, BusAutoResourceParameters
from sandbox.projects.rasp.bus.utils.resources import CarrierDictResource, CarrierMatchingResource, \
    PointMatchingResource, SupplierDictResource, RegisterTypeResource


log = logging.getLogger(__name__)


class BusAdminDictsUpdate(ReleaseToNannyAndYaDeployTask2, BusBaseTaskAutoResource):

    RESOURCE_PATH = 'bus_admin_dicts_resources'
    RESOURCE_TTL = 90

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024
        ram = 2048

    class Parameters(BusAutoResourceParameters):
        pass

    def on_execute(self):
        super(BusAdminDictsUpdate, self).on_execute()
        environ['YENV_TYPE'] = self.Parameters.environment
        environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')

        resource_path = Path(self.RESOURCE_PATH)
        resource_path.mkdir(parents=True, exist_ok=True)

        from travel.rasp.bus.scripts.admin_dicts_dumper import AdminDictsDumper
        dumper = AdminDictsDumper(directory=self.RESOURCE_PATH)

        for resource_type, gen_func in [
            (SupplierDictResource, dumper.dump_supplier_dict),
            (CarrierDictResource, dumper.dump_carrier_dict),
            (CarrierMatchingResource, dumper.dump_carrier_matching_dict),
            (PointMatchingResource, dumper.dump_point_matching_dict),
            (RegisterTypeResource, dumper.dump_register_type_dict),
        ]:
            path = gen_func()
            name = os_path.basename(path)
            resource = resource_type(self, path=name, resource_name=name, description=name, ttl=self.RESOURCE_TTL)
            log.info("%s generated", name)
            resource_data = sdk2.ResourceData(resource)
            copy(src=path, dst=str(resource_data.path.absolute()))
            resource_data.ready()
            log.info("%s ready", name)
        log.info("all done")
