# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from os import environ
from pathlib2 import Path
from shutil import copy

from sandbox import sdk2
from sandbox.projects.common.ya_deploy.release_integration import ReleaseToNannyAndYaDeployTask2
from sandbox.projects.rasp.bus.BusBaseTask import BusBaseTaskAutoResource, BusAutoResourceParameters
from sandbox.projects.rasp.bus.utils import get_data_resource
from sandbox.projects.rasp.bus.utils.resources import PointkeyFilterResource
from sandbox.projects.Travel.resources import dicts


log = logging.getLogger(__name__)


class BusTTypeFilterUpdate(ReleaseToNannyAndYaDeployTask2, BusBaseTaskAutoResource):

    RESOURCE_PATH = 'bus_ttype_filter_resources'
    TTYPE_FILTER_RESOURCE_NAME = 'ttypefilter.msgpack'
    TTYPE = 'bus'
    RESOURCE_TTL = 30

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024
        ram = 2048

    class Parameters(BusAutoResourceParameters):
        station_resource = sdk2.parameters.Resource(
            'station.bin (last if empty)',
            resource_type=[dicts.TRAVEL_DICT_RASP_STATION_PROD],
            required=False,
        )
        settlement_resource = sdk2.parameters.Resource(
            'settlement.bin (last if empty)',
            resource_type=[dicts.TRAVEL_DICT_RASP_SETTLEMENT_PROD],
            required=False,
        )

    def on_execute(self):
        super(BusTTypeFilterUpdate, self).on_execute()
        environ['YENV_TYPE'] = self.Parameters.environment
        environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')
        from travel.rasp.bus.scripts.pointkey_filter import PointKeyFilterGenerator

        station_resource = self.Parameters.station_resource or get_data_resource(dicts.TRAVEL_DICT_RASP_STATION_PROD)
        settlement_resource = self.Parameters.settlement_resource \
            or get_data_resource(dicts.TRAVEL_DICT_RASP_SETTLEMENT_PROD)
        assert station_resource and settlement_resource
        station_resource_data = sdk2.ResourceData(station_resource)
        settlement_resource_data = sdk2.ResourceData(settlement_resource)
        log.info('Got resource data')

        resource_path = Path(self.RESOURCE_PATH)
        resource_path.mkdir(parents=True, exist_ok=True)

        ttype_filename = str(resource_path / self.TTYPE_FILTER_RESOURCE_NAME)
        pointkey_filter_generator = PointKeyFilterGenerator()
        pointkey_filter_generator.gen(
            station_fn=str(station_resource_data.path.absolute()),
            settlement_fn=str(settlement_resource_data.path.absolute()),
            pointkey_fn=ttype_filename,
            ttype=self.TTYPE
        )

        log.info('%s generated', self.TTYPE_FILTER_RESOURCE_NAME)

        ttype_filter_resource = PointkeyFilterResource(
            self, description=self.TTYPE_FILTER_RESOURCE_NAME, path=self.TTYPE_FILTER_RESOURCE_NAME,
            resource_name=self.TTYPE_FILTER_RESOURCE_NAME, ttl=self.RESOURCE_TTL
        )
        pk_resource_data = sdk2.ResourceData(ttype_filter_resource)
        copy(src=ttype_filename, dst=str(pk_resource_data.path.absolute()))
        pk_resource_data.ready()
        log.info('TTypeFilterResource %s ready. Done', self.TTYPE_FILTER_RESOURCE_NAME)
