# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from os import environ

from sandbox import sdk2
from sandbox.projects.rasp.bus.BusBaseTask import BusBaseTaskAutoResource, BusAutoResourceParameters


class BusSalesmon(BusBaseTaskAutoResource):

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024
        ram = 2048

    class Parameters(BusAutoResourceParameters):
        with sdk2.parameters.Group("Sales monitor") as params:
            dry = sdk2.parameters.Bool('Dry', default=True, required=True)
            suppliers = sdk2.parameters.List('Suppliers (all if empty)', default=[], required=True)
            threshold = sdk2.parameters.Float("Sales threshold", required=True, default=0.35)
            history_periods = sdk2.parameters.Integer("Weeks to load for check", required=True, default=4)
            small_day_sales = sdk2.parameters.Integer("Small supplier mark (day sales lower than)",
                                                      required=True, default=100)
            sales_estimation_days = sdk2.parameters.Integer("Period of sales for load, days", required=True, default=30)
            small_sales_threshold_ratio = sdk2.parameters.Float("Small supplier threshold ratio",
                                                                required=True, default=3)
            threshold_sensitivity = sdk2.parameters.Integer("Threshold sensitivity, sales/hour",
                                                            required=True, default=10)

    def on_execute(self):
        super(BusSalesmon, self).on_execute()

        environ['YENV_TYPE'] = self.Parameters.environment
        environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')
        from travel.rasp.bus.scripts.sales_monitor import SalesMonitor

        salesmon = SalesMonitor(
            self.task_tracker_config.solomon_token,
            self.Parameters.suppliers,
            threshold=self.Parameters.threshold,
            threshold_sensitivity=self.Parameters.threshold_sensitivity,
            history_values_num=self.Parameters.history_periods,
            small_day_sales=self.Parameters.small_day_sales,
            sales_estimation_days=self.Parameters.sales_estimation_days,
            small_sales_threshold_ratio=self.Parameters.small_sales_threshold_ratio,
            environment=self.Parameters.environment,
            dry_run=self.Parameters.dry,
        )
        salesmon.run()

        logging.info("Done!")
