# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging

from os import environ

from sandbox import sdk2
from sandbox.projects.rasp.bus.BusBaseTask import BusBaseTaskAutoResource, BusAutoResourceParameters


class BusSitemap(BusBaseTaskAutoResource):

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024
        ram = 2048

    class Parameters(BusAutoResourceParameters):
        with sdk2.parameters.Group("Sitemap") as params:
            dry = sdk2.parameters.Bool('Dry', default=True, required=True)
            popular_limit = sdk2.parameters.Integer("Popular directions limit", required=True, default=15000)
            min_upload_threshold = sdk2.parameters.Integer("Minimal upload threshold", required=True, default=3000)

    def on_execute(self):
        super(BusSitemap, self).on_execute()

        environ['YENV_TYPE'] = self.Parameters.environment
        environ['RASP_VAULT_OAUTH_TOKEN'] = sdk2.Vault.data(self.Parameters.sandbox_vault_owner, 'YAV_OAUTH_TOKEN')
        from travel.rasp.bus.scripts.sitemap import Sitemap

        sitemap = Sitemap(
            self.Parameters.popular_limit,
            self.Parameters.min_upload_threshold,
            dry=self.Parameters.dry
        )
        sitemap.run()

        logging.info("Done!")
