# Sandbox задачи, связанные с сервисом Яндекс.Автобусов

## Базовый класс
Все задачи сервиса, к которым предъявляются требования по мониторингу, должны наследоваться от базового класса BusBaseTaskAutoResource. \
В нем реализована логика мониторинга выполнения задачи, отправки результатов в Solomon и поиск подходящего ресурса бинарника.

Параметры задач необходимо наследовать от базового класса BusBaseParameters - в нем содержится стандартное для сервиса разделение на окружения.

## Отчеты

### BusOrderReport
Задача, которая генерирует отчет о обороте сервиса Яндекс.Автобусы за фиксированные периоды (по умолчанию предыдущий месяц)

## Сброс кэшей

### BusResetSegmentCache
Задача, которая сбрасывает кэш сегментов и просит сервисы, обновить свой кэш сегментов из памяти. \
Задача работает в двух режимах:
1. С указаным списком поставщиков, тогда будет операция выполнена для каждого из них
2. Без указания списка поставщиков, тогда операция будет выболнена ДЛЯ ВСЕХ поставщиков

### BusResetSearchResultCacheByDirection
Задача, которая сбрасывает кэш сохраненных вариантов поиска по ключу: \
``Поставщик - Откуда - Куда - Любой день`` \
Так же в задаче есть поддержка сброса кэша для обоих направлениях

### BusResetSearchResultCacheByParticularDirection
Задача, которая сбрасывает кэш сохраненных вариантов поиска по ключу: \
``Поставщик - Откуда - Куда - Конкретная дата``

### BusResetSearchResultCacheByPoint
Задача, которая сбрасывает кэш сохраненных вариантов поиска по ключaм:
1. ``Поставщик - Выбранная точка - Любая точка - Любой день``
2. ``Поставщик - Любая точка - Выбранная точка - Любой день``

## F.A.Q.
1. Что значит параметр Dry? \
Если Sandbox задача может попортить значения в проде, то я старался добавить флаг Dry. Если он выставлен в True, то задача не будет как-то менять состояние данных. \
Если выставлено в False, то данные будут изменены. Следовательно, если вы не понимаете что делаете, то лучше программу запустить с флагом True и почитать логи.

2. Как понять что программа сделала? \
Открываете common.log в sandbox и читаете.`
