import logging

from sandbox.common.types.resource import State

log = logging.getLogger(__name__)


def get_data_resource(resource_class):
    resource = resource_class.find(
        state=State.READY,
        order=['-created'],
        limit=1,
    ).first()
    if not resource:
        log.error('No resource with type of %s found', resource_class)
        return None
    log.info('Using %r', resource)
    return resource


def update_qloud_resources(sb_resources, qloud_environment, qloud_component, qloud_api):
    env_dump = qloud_api.dump_environment(qloud_environment)
    changed = False
    for component_dump in env_dump.get('components', []):
        if component_dump.get('componentName') != qloud_component:
            continue
        for resource_dump in component_dump.get('sandboxResources', []):
            for res in sb_resources:
                if resource_dump.get('localName') != res.resource_name:
                    continue
                prev_id = resource_dump['id']
                if prev_id == res.id:
                    continue
                resource_dump['id'] = res.id
                changed = True
                log.info('Sandbox resource changed: %s -> %s', prev_id, resource_dump['id'])
    if not changed:
        log.error('Nothing for update')
        return
    qloud_api.upload_environment(env_dump)
    log.info('%s.%s was updated', qloud_environment, qloud_component)
