# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals


from sandbox import sdk2


RELEASERS = ['robot-sputnik', 'ganintsev', 'maxim-k', 'ypetrov', 'maxim-sazonov']


class _BusesResource(sdk2.Resource):
    releasable = True
    auto_backup = True
    environment = sdk2.Attributes.String('Environment')
    resource_name = sdk2.parameters.String('Resource name')
    releasers = RELEASERS


class PointkeyFilterResource(_BusesResource):
    pass


class SupplierDictResource(_BusesResource):
    pass


class CarrierDictResource(_BusesResource):
    pass


class CarrierMatchingResource(_BusesResource):
    pass


class PointMatchingResource(_BusesResource):
    pass


class RegisterTypeResource(_BusesResource):
    pass


class AutoMatcherResource(sdk2.Resource):
    auto_backup = True


class _BusesBinaryRelease(sdk2.Resource):
    releasable = True
    auto_backup = True
    executable = True
    ttl = 'inf'
    releasers = RELEASERS


class BUSES_ADMIN_BINARY(_BusesBinaryRelease):
    pass


class BUSES_BACKEND_API_BINARY(_BusesBinaryRelease):
    pass


class BUSES_BACKEND_WARMER_BINARY(_BusesBinaryRelease):
    pass


class BUSES_BACKEND_WORKER_BINARY(_BusesBinaryRelease):
    pass


class BUSES_BACKEND_TESTCONTEXT_BINARY(_BusesBinaryRelease):
    pass


class BUSES_CONNECTORS_BINARY(_BusesBinaryRelease):
    pass


class BUSES_SUGGESTS_BINARY(_BusesBinaryRelease):
    pass
